/*
 * Decompiled with CFR 0.152.
 */
package music;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import music.Main;
import music.commonUtils;
import music.settings;
import music.songConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class musicScore {
    public String[] concertScore;
    public String[] displayScore;
    public int[] countScore;
    public float[] timeScore;
    public int[] BPMarray;
    public int currentBPM;
    private static int[] octaveChoice;

    public musicScore() {
        octaveChoice = new int[settings.maxNumOctavesDuringConversion];
        for (int x = octaveChoice.length - 1; x >= 0; --x) {
            musicScore.octaveChoice[x] = x + 3;
        }
    }

    public void timeScoreToCountScore() {
        if (this.countScore == null || this.countScore.length != this.timeScore.length + 1) {
            this.countScore = new int[this.timeScore.length + 1];
        }
        int cumTime = settings.screenWidth + settings.PPB / 4;
        for (int c = 0; c < this.timeScore.length; ++c) {
            this.countScore[c] = cumTime;
            cumTime += (int)this.timeScore[c] * settings.PPB;
        }
        this.countScore[this.timeScore.length] = cumTime;
    }

    public void countScoreToTimeScore() {
        if (this.timeScore == null || this.timeScore.length != this.countScore.length - 1) {
            this.timeScore = new float[this.countScore.length - 1];
        }
        for (int c = 0; c < this.timeScore.length; ++c) {
            this.timeScore[c] = (float)(this.countScore[c + 1] - this.countScore[c]) / (float)settings.PPB;
        }
    }

    private int BPMatTime(double time) {
        for (int x = this.BPMarray.length - 1; x >= 0; --x) {
            if (x % 2 == 1) continue;
            if (x == 0) {
                return this.BPMarray[0];
            }
            if (!(time >= (double)this.BPMarray[x])) continue;
            return this.BPMarray[x - 1];
        }
        return this.BPMarray[0];
    }

    public void concertAndDisplayTranspose(int concertTrans, int displayTrans) {
        this.concertScore = musicScore.transpose(this.concertScore, concertTrans);
        this.displayScore = musicScore.transpose((String[])this.concertScore.clone(), displayTrans);
    }

    public boolean findAccidentals() {
        int sharps = 0;
        int flats = 0;
        for (int n = this.displayScore.length - 1; n >= 0; --n) {
            if (this.displayScore[n].equals("#")) {
                ++sharps;
                continue;
            }
            if (!this.displayScore[n].equals("b")) continue;
            ++flats;
        }
        return sharps >= flats;
    }

    public boolean haveNotReachedEnd() {
        return this.countScore[this.countScore.length - 1] > 0;
    }

    public void Print() {
        block2: {
            System.out.print("Concert Score: ");
            this.printPart(this.concertScore);
            System.out.print("Display Score: ");
            this.printPart(this.displayScore);
            System.out.print("Time Score: ");
            this.printPart(this.timeScore);
            System.out.print("Count Score: ");
            this.printPart(this.countScore);
            System.out.print("BPM:");
            this.printPart(this.BPMarray);
            System.out.print('\n');
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ex) {
                if (!Main.debugErrors) break block2;
                System.out.println(ex);
            }
        }
    }

    public void writeFile(String fileName) {
        block2: {
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(fileName));
                bw.write(this.toString());
                bw.close();
            }
            catch (IOException ex) {
                if (!Main.debugErrors) break block2;
                System.out.println(ex);
            }
        }
    }

    public void readFile(File file, int pxlCount) {
        this.loadText(musicScore.inputScore(file), pxlCount);
    }

    public void loadText(String text) {
        this.loadText(text, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadText(String text, int pxlCount) {
        int BPMchanges;
        String[] Old = musicScore.scoreStringToArray(text);
        if (musicScore.stringIsInt(Old[0])) {
            BPMchanges = 1;
            for (int aa = 1; aa < Old.length; ++aa) {
                if (!musicScore.stringIsInt(Old[aa]) || !musicScore.stringIsInt(Old[aa - 1])) continue;
                ++BPMchanges;
            }
        } else {
            BPMchanges = 0;
        }
        this.concertScore = new String[(Old.length - BPMchanges) / 2 + 1];
        this.countScore = new int[this.concertScore.length];
        int scoreIndex = 0;
        int BPMarrayIndex = 0;
        int aa = 0;
        if (this.BPMarray == null) {
            try {
                short y = Short.parseShort(Old[0]);
                this.BPMarray = new int[2 * BPMchanges - 1];
                this.BPMarray[BPMarrayIndex++] = y;
                ++aa;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        while (true) {
            block13: {
                block14: {
                    if (aa >= Old.length) {
                        this.concertScore[this.concertScore.length - 1] = "";
                        this.countScore[this.countScore.length - 1] = pxlCount;
                        return;
                    }
                    if (!musicScore.stringIsInt(Old[aa])) break block14;
                    if (musicScore.stringIsInt(Old[aa - 1])) {
                        this.BPMarray[BPMarrayIndex++] = Integer.parseInt(Old[aa]);
                        this.BPMarray[BPMarrayIndex++] = pxlCount;
                        break block13;
                    } else {
                        try {
                            pxlCount += musicScore.stringToPixelInt(Old[aa]);
                        }
                        catch (Exception ex) {
                            if (Main.debugErrors) {
                                System.out.println("Error in loadText function in class musicScore: " + Old[aa] + " " + ex);
                            }
                            break block13;
                        }
                    }
                }
                this.concertScore[scoreIndex] = Old[aa];
                this.countScore[scoreIndex++] = pxlCount;
            }
            ++aa;
        }
    }

    public String[] range() {
        String note = null;
        String minNote = null;
        String maxNote = null;
        int minOctave = -1;
        int maxOctave = -1;
        int st = this.displayScore.length;
        for (int counter = 0; counter < st; ++counter) {
            if (!musicScore.isNote(this.displayScore[counter])) continue;
            int octave = Integer.parseInt(this.displayScore[counter].substring(this.displayScore[counter].length() - 1));
            if (minOctave != -1 && maxOctave != -1) {
                note = this.displayScore[counter].substring(0, 1);
                if (octave <= minOctave) {
                    if (musicScore.compare(note, minNote.substring(0, 1)) < 0) {
                        minOctave = octave;
                        minNote = this.displayScore[counter].substring(0, this.displayScore[counter].length() - 1);
                    } else if (musicScore.compare(note, minNote.substring(0, 1)) == 0) {
                        minOctave = octave;
                        if (this.displayScore[counter].length() > 1) {
                            if (this.displayScore[counter].length() > 1 && this.displayScore[counter].charAt(1) == 'b') {
                                minNote = this.displayScore[counter].substring(0, this.displayScore[counter].length() - 1);
                            } else if (minNote.length() > 1 && minNote.charAt(1) == '#') {
                                minNote = this.displayScore[counter].substring(0, this.displayScore[counter].length() - 1);
                            }
                        }
                    }
                }
                if (octave < maxOctave) continue;
                if (musicScore.compare(note, maxNote.substring(0, 1)) > 0) {
                    maxOctave = octave;
                    maxNote = this.displayScore[counter].substring(0, this.displayScore[counter].length() - 1);
                    continue;
                }
                if (musicScore.compare(note, maxNote.substring(0, 1)) != 0) continue;
                maxOctave = octave;
                if (this.displayScore[counter].length() <= 1) continue;
                if (this.displayScore[counter].length() > 1 && this.displayScore[counter].charAt(1) == '#') {
                    maxNote = this.displayScore[counter].substring(0, this.displayScore[counter].length() - 1);
                    continue;
                }
                if (maxNote.length() <= 1 || maxNote.charAt(1) != 'b') continue;
                maxNote = this.displayScore[counter].substring(0, this.displayScore[counter].length() - 1);
                continue;
            }
            minOctave = octave;
            maxOctave = octave;
            minNote = this.displayScore[counter].substring(0, this.displayScore[counter].length() - 1);
            maxNote = this.displayScore[counter].substring(0, this.displayScore[counter].length() - 1);
        }
        try {
            String[] RANGE = new String[]{minNote.concat(Integer.toString(minOctave)), maxNote.concat(Integer.toString(maxOctave))};
            return RANGE;
        }
        catch (NullPointerException n) {
            String[] RANGE = new String[]{"was not possible", "compute"};
            return RANGE;
        }
    }

    public static int compare(String one, String two) {
        if (one.charAt(0) == 'A') {
            one = one.replace('A', 'H');
        } else if (one.charAt(0) == 'B') {
            one = one.replace('B', 'I');
        }
        if (two.charAt(0) == 'A') {
            two = two.replace('A', 'H');
        } else if (two.charAt(0) == 'B') {
            two = two.replace('B', 'I');
        }
        return one.compareTo(two);
    }

    public String toString() {
        if (this.timeScore == null) {
            this.countScoreToTimeScore();
        }
        int BPMcount = 0;
        StringBuffer score = new StringBuffer();
        score.append(Integer.toString(this.BPMarray[BPMcount++]).concat(" "));
        if (this.concertScore.length != this.timeScore.length + 1 && Main.debugErrors) {
            System.out.println("ConcertScore and timeScore mismatch!");
            this.Print();
        }
        float cumTime = 0.0f;
        for (int ii = 0; ii < this.concertScore.length - 1; ++ii) {
            if (this.concertScore[ii].equals("")) {
                score.append("_");
            } else {
                score.append(this.concertScore[ii]);
            }
            score.append(" ").append(commonUtils.doubleToStringFraction(this.timeScore[ii])).append(" ");
            cumTime += this.timeScore[ii];
            if (BPMcount + 1 >= this.BPMarray.length || !(cumTime > (float)this.BPMarray[BPMcount + 1])) continue;
            score.append(this.BPMarray[BPMcount]).append(" ");
            BPMcount += 2;
        }
        return score.toString();
    }

    public void appendNote(String i) {
        if (this.concertScore == null) {
            this.concertScore = new String[1];
            this.concertScore[0] = i;
        } else {
            this.concertScore = musicScore.resizeArray(this.concertScore, this.concertScore.length + 1);
            this.concertScore[this.concertScore.length - 1] = i;
        }
    }

    public void appendTime(float i) {
        if (this.timeScore == null) {
            this.timeScore = new float[1];
            this.timeScore[0] = i;
        } else {
            this.timeScore = musicScore.resizeArray(this.timeScore, this.timeScore.length + 1);
            this.timeScore[this.timeScore.length - 1] = i;
        }
    }

    public void appendBPM(int i) {
        if (this.BPMarray == null) {
            this.BPMarray = new int[1];
            this.BPMarray[0] = i;
        } else {
            this.BPMarray = musicScore.resizeArray(this.BPMarray, this.BPMarray.length + 1);
            this.BPMarray[this.BPMarray.length - 1] = i;
        }
    }

    public void loadIntArray(int[] load) {
        double totalTime = 0.0;
        for (int x = 0; x < load.length; ++x) {
            if (x % 2 == 0) {
                this.appendNote(musicScore.numToNote(load[x]));
                continue;
            }
            int BPM = this.BPMatTime(totalTime);
            float deltaT = (float)BPM / 60.0f * (float)load[x] / 40.0f;
            totalTime += (double)deltaT;
            this.appendTime(deltaT);
        }
        this.appendNote("");
        this.attachMinEnergyOctavesToNotes();
        this.timeScoreToCountScore();
    }

    public void attachMinEnergyOctavesToNotes() {
        int[] oct = this.minEnergyOctaves(this.concertScore);
        if (oct.length == this.concertScore.length) {
            for (int x = oct.length - 1; x >= 0; --x) {
                int n = x;
                this.concertScore[n] = this.concertScore[n] + Integer.toString(oct[x]);
            }
        } else if (Main.debugErrors) {
            System.out.println("Octaves and notes should be same length: " + oct.length + " " + this.concertScore.length);
            System.out.println("Octaves: " + oct.toString());
            System.out.println("Score: " + this.concertScore.toString());
        }
    }

    private int[] minEnergyOctaves(String[] notes) {
        int x;
        int[][][] dp = new int[notes.length][octaveChoice.length][1 + notes.length];
        for (x = 0; x < dp[0].length; ++x) {
            dp[0][x][0] = 0;
            dp[0][x][1] = octaveChoice[x];
        }
        for (x = 1; x < dp.length; ++x) {
            for (int y = 0; y < dp[x].length; ++y) {
                int z = 0;
                double[] choices = new double[octaveChoice.length];
                for (z = 0; z < dp[x].length; ++z) {
                    choices[z] = musicScore.intervalCost(Math.abs(musicScore.interval(notes[x], notes[x - 1]) + 12 * (z - y)));
                }
                int index = commonUtils.indexOf(commonUtils.min(choices), choices);
                dp[x][y][0] = (int)(commonUtils.min(choices) + (double)dp[x - 1][index][0]);
                for (z = 1; z <= x; ++z) {
                    dp[x][y][z] = dp[x - 1][index][z];
                }
                dp[x][y][z] = octaveChoice[y];
            }
        }
        int minEnergy = Integer.MAX_VALUE;
        int minPointer = -1;
        for (int y = 0; y < dp[0].length; ++y) {
            if (dp[dp.length - 1][y][0] >= minEnergy) continue;
            minEnergy = dp[dp.length - 1][y][0];
            minPointer = y;
        }
        int[] answer = new int[notes.length];
        for (int x2 = answer.length - 1; x2 >= 0; --x2) {
            answer[x2] = dp[dp.length - 1][minPointer][x2 + 1];
        }
        return answer;
    }

    private static int[] resizeArray(int[] oldArray, int newSize) {
        int oldSize = oldArray.length;
        int[] newArray = new int[newSize];
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    private static float[] resizeArray(float[] oldArray, int newSize) {
        int oldSize = oldArray.length;
        float[] newArray = new float[newSize];
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    private static String[] resizeArray(String[] oldArray, int newSize) {
        int oldSize = oldArray.length;
        String[] newArray = new String[newSize];
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    private static String inputScore(File fileName) {
        String text;
        block2: {
            text = "";
            try {
                BufferedReader in = new BufferedReader(new FileReader(fileName));
                text = in.readLine();
                in.close();
            }
            catch (IOException e) {
                if (!Main.debugErrors) break block2;
                System.out.println("Error in musicScore.inputScore function: " + e);
            }
        }
        return text;
    }

    private static String[] scoreStringToArray(String text) {
        StringTokenizer st = new StringTokenizer(text, " ");
        int tokenCount = st.countTokens();
        String[] inputScore = new String[tokenCount];
        for (int i = 0; i < tokenCount; ++i) {
            String strg = st.nextToken();
            inputScore[i] = strg.equals("_") ? "" : strg;
        }
        return inputScore;
    }

    private static boolean stringIsInt(String a) {
        try {
            Integer.parseInt(a);
        }
        catch (NumberFormatException NFE) {
            try {
                musicScore.stringToPixelInt(a);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private static int stringToPixelInt(String f) throws Exception {
        StringTokenizer s = new StringTokenizer(f, "/");
        int tokenCount = s.countTokens();
        if (tokenCount != 2) {
            return settings.PPB * Integer.parseInt(f);
        }
        String[] fraction = new String[tokenCount];
        for (int i = 0; i < tokenCount; ++i) {
            fraction[i] = s.nextToken();
        }
        int store = Integer.parseInt(fraction[0]) * settings.PPB;
        int denom = Integer.parseInt(fraction[1]);
        int Int = store / denom;
        if (store % denom > denom / 2) {
            ++Int;
        }
        return Int;
    }

    public void simplifyTrack() {
        this.checkMinMaxNoteLengths();
        this.checkMaxIntervals();
    }

    private void checkMinMaxNoteLengths() {
        float minNL;
        float maxNL;
        float minRL;
        float maxRL;
        block8: {
            maxRL = 0.0f;
            minRL = 0.0f;
            maxNL = 0.0f;
            minNL = 0.0f;
            try {
                maxRL = (float)songConverter.stringToDouble(settings.maxRestLength);
                minRL = (float)songConverter.stringToDouble(settings.minRestLength);
                maxNL = (float)songConverter.stringToDouble(settings.maxNoteLength);
                minNL = (float)songConverter.stringToDouble(settings.minNoteLength);
            }
            catch (Exception e) {
                if (!Main.debugErrors) break block8;
                System.out.println(e);
            }
        }
        float cumTime = 0.0f;
        for (int x = 0; x < this.concertScore.length - 1; ++x) {
            if (this.concertScore[x].equals("")) {
                if (this.timeScore[x] > maxRL) {
                    this.fixBPM(cumTime, this.timeScore[x] - maxRL);
                    this.timeScore[x] = maxRL;
                    cumTime += maxRL;
                    continue;
                }
                if (this.timeScore[x] < minRL) {
                    this.throwOutNote(x, this.timeScore[x]);
                    cumTime += this.timeScore[x];
                    continue;
                }
                cumTime += this.timeScore[x];
                continue;
            }
            if (this.timeScore[x] > maxNL) {
                this.fixBPM(cumTime, this.timeScore[x] - maxNL);
                this.timeScore[x] = maxNL;
                cumTime += maxNL;
                continue;
            }
            if (this.timeScore[x] < minNL) {
                this.throwOutNote(x, this.timeScore[x]);
                cumTime += this.timeScore[x];
                continue;
            }
            cumTime += this.timeScore[x];
        }
    }

    private void throwOutNote(int index, float incAmount) {
        int x;
        String[] scoreCopy = new String[this.concertScore.length - 1];
        float[] timeCopy = new float[this.timeScore.length - 1];
        for (x = index - 1; x >= 0; --x) {
            scoreCopy[x] = this.concertScore[x];
            timeCopy[x] = this.timeScore[x];
        }
        if (index != 0) {
            int n = index - 1;
            timeCopy[n] = timeCopy[n] + incAmount;
        }
        for (x = index + 1; x < this.concertScore.length; ++x) {
            scoreCopy[x - 1] = this.concertScore[x];
            timeCopy[x - 1] = this.timeScore[x];
        }
        this.concertScore = scoreCopy;
        this.timeScore = timeCopy;
    }

    private void fixBPM(float cumTime, float changeAmount) {
        for (int x = 2; x < this.BPMarray.length; x += 2) {
            if (!((float)this.BPMarray[x] > cumTime)) continue;
            int n = x;
            this.BPMarray[n] = (int)((float)this.BPMarray[n] - changeAmount);
        }
    }

    private void checkMaxIntervals() {
        String[] notes = new String[this.concertScore.length - 1];
        byte[] oct = new byte[notes.length];
        notes[notes.length - 1] = "";
        oct[oct.length - 1] = -127;
        for (int x = notes.length - 2; x >= 0; --x) {
            if (this.concertScore[x].equals("")) {
                notes[x] = "";
                oct[x] = -127;
                continue;
            }
            oct[x] = Byte.parseByte(this.concertScore[x].substring(this.concertScore[x].length() - 1));
            notes[x] = this.concertScore[x].substring(0, this.concertScore[x].length() - 1);
        }
        int range = commonUtils.max(oct) - commonUtils.min(oct, (byte)-126) + 1;
        int start = (int)Math.round(commonUtils.avg(oct));
        if (range <= settings.maxNumOctavesDuringConversion) {
            return;
        }
        oct = musicScore.fitWithinIntervals(notes, oct, start, settings.maxNumOctavesDuringConversion, settings.maxInterval);
        for (int x = 0; x < notes.length - 1; ++x) {
            this.concertScore[x] = notes[x];
            if (notes[x].equals("")) continue;
            int n = x;
            this.concertScore[n] = this.concertScore[n] + Byte.toString(oct[x]);
        }
    }

    private static byte[] fitWithinIntervals(String[] n, byte[] o, int s, int maxOctaves, int maxInterval) {
        int y;
        int x;
        for (int y2 = 0; y2 < o.length; ++y2) {
        }
        int[][][] table = new int[o.length][maxOctaves][2];
        int octIncr = s - (maxOctaves - 1) / 2;
        for (x = 0; x < table[0].length; x = (int)((byte)(x + 1))) {
            table[table.length - 1][x][0] = Math.abs(o[table.length - 1] - (x + octIncr));
        }
        for (x = table.length - 2; x >= 0; --x) {
            int optInterval;
            int y3;
            if (n[x].equals("") || n[x + 1].equals("")) {
                int min = Integer.MAX_VALUE;
                int minInd = -1;
                for (y3 = table[x].length - 1; y3 >= 0; --y3) {
                    if (table[x + 1][y3][0] >= min) continue;
                    min = table[x + 1][y3][0];
                    minInd = y3;
                }
                for (y3 = table[x].length - 1; y3 >= 0; --y3) {
                    table[x][y3][0] = min;
                    table[x][y3][1] = minInd;
                    if (n[x].equals("")) continue;
                    int[] nArray = table[x][y3];
                    nArray[0] = nArray[0] + Math.abs(o[x] - (y3 + octIncr));
                }
                continue;
            }
            int noteInterval = musicScore.interval(n[x], n[x + 1]);
            for (optInterval = 12 * (o[x + 1] - o[x]) + noteInterval; optInterval > maxInterval; optInterval -= 12) {
            }
            for (y3 = table[x].length - 1; y3 >= 0; --y3) {
                int best = Integer.MAX_VALUE;
                int bestIndex = -1;
                for (int z = table[x].length - 1; z >= 0; --z) {
                    int interval = 12 * (z - y3) + noteInterval;
                    int score = Math.abs(interval - optInterval) + table[x + 1][z][0];
                    if (score >= best) continue;
                    best = score;
                    bestIndex = z;
                }
                table[x][y3][0] = best + Math.abs(o[x] - (y3 + octIncr));
                table[x][y3][1] = bestIndex;
            }
        }
        int min = Integer.MAX_VALUE;
        int minIndex = 0;
        for (y = table[0].length - 1; y >= 0; --y) {
            if (table[0][y][0] >= min) continue;
            min = table[0][y][0];
            minIndex = y;
        }
        for (int x2 = 0; x2 < table.length; ++x2) {
            o[x2] = (byte)(minIndex + octIncr);
            minIndex = table[x2][minIndex][1];
        }
        for (y = 0; y < o.length; ++y) {
        }
        return o;
    }

    private static int interval(String note1, String note2) {
        return musicScore.stringToNote(note2) - musicScore.stringToNote(note1);
    }

    private static double intervalCost(int s) {
        double[] p = new double[]{2.702, 2.573, 1.558, 3.807, 4.264, 3.492, 31.623, 4.938, 18.257, 11.952, 11.952, 11.952, 6.086, 14.142, 31.623, 15.811};
        if (Math.abs(s) >= p.length) {
            return 50.0;
        }
        return p[Math.abs(s)];
    }

    private static int stringToNote(String s) {
        if (s.equals("C")) {
            return 0;
        }
        if (s.equals("C#")) {
            return 1;
        }
        if (s.equals("D")) {
            return 2;
        }
        if (s.equals("D#")) {
            return 3;
        }
        if (s.equals("E")) {
            return 4;
        }
        if (s.equals("F")) {
            return 5;
        }
        if (s.equals("F#")) {
            return 6;
        }
        if (s.equals("G")) {
            return 7;
        }
        if (s.equals("G#")) {
            return 8;
        }
        if (s.equals("A")) {
            return 9;
        }
        if (s.equals("A#")) {
            return 10;
        }
        if (s.equals("B")) {
            return 11;
        }
        if (Main.debugErrors) {
            System.out.println("Error in stringToNote input: " + s);
        }
        return 12;
    }

    public static String numToNote(int n) {
        switch (n) {
            case 0: {
                return "A";
            }
            case 1: {
                return "A#";
            }
            case 2: {
                return "B";
            }
            case 3: {
                return "C";
            }
            case 4: {
                return "C#";
            }
            case 5: {
                return "D";
            }
            case 6: {
                return "D#";
            }
            case 7: {
                return "E";
            }
            case 8: {
                return "F";
            }
            case 9: {
                return "F#";
            }
            case 10: {
                return "G";
            }
            case 11: {
                return "G#";
            }
        }
        if (Main.debugErrors) {
            System.out.println("Error in musicScore.numToNote input: " + n);
        }
        return "";
    }

    private static boolean isNote(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (Exception e) {
            return !str.contains("/") && str.length() != 0;
        }
        return false;
    }

    public static String[] transpose(String[] score, int halfSteps) {
        while (halfSteps < 0) {
            score = musicScore.changeOctave(score, -1);
            halfSteps += 12;
        }
        while (halfSteps >= 12) {
            score = musicScore.changeOctave(score, 1);
            halfSteps -= 12;
        }
        if (halfSteps == 0) {
            return score;
        }
        for (int counter = score.length - 1; counter >= 0; --counter) {
            if (score[counter].equals("")) continue;
            String note = score[counter].substring(0, score[counter].length() - 1);
            String octave = score[counter].substring(score[counter].length() - 1);
            switch (score[counter].charAt(0)) {
                case 'A': {
                    if (note.equals("Ab")) {
                        score[counter] = "A";
                        break;
                    }
                    if (note.equals("A")) {
                        score[counter] = "A#";
                        break;
                    }
                    if (!note.equals("A#")) break;
                    score[counter] = "B";
                    break;
                }
                case 'B': {
                    if (note.equals("Bb")) {
                        score[counter] = "B";
                        break;
                    }
                    if (note.equals("B")) {
                        score[counter] = "C";
                        octave = Integer.toString(Integer.valueOf(octave) + 1);
                        break;
                    }
                    if (!note.equals("B#")) break;
                    score[counter] = "C#";
                    octave = Integer.toString(Integer.valueOf(octave) + 1);
                    break;
                }
                case 'C': {
                    if (note.equals("Cb")) {
                        score[counter] = "C";
                        break;
                    }
                    if (note.equals("C")) {
                        score[counter] = "C#";
                        break;
                    }
                    if (!note.equals("C#")) break;
                    score[counter] = "D";
                    break;
                }
                case 'D': {
                    if (note.equals("Db")) {
                        score[counter] = "D";
                        break;
                    }
                    if (note.equals("D")) {
                        score[counter] = "D#";
                        break;
                    }
                    if (!note.equals("D#")) break;
                    score[counter] = "E";
                    break;
                }
                case 'E': {
                    if (note.equals("Eb")) {
                        score[counter] = "E";
                        break;
                    }
                    if (note.equals("E")) {
                        score[counter] = "F";
                        break;
                    }
                    if (!note.equals("E#")) break;
                    score[counter] = "F#";
                    break;
                }
                case 'F': {
                    if (note.equals("Fb")) {
                        score[counter] = "F";
                        break;
                    }
                    if (note.equals("F")) {
                        score[counter] = "F#";
                        break;
                    }
                    if (!note.equals("F#")) break;
                    score[counter] = "G";
                    break;
                }
                case 'G': {
                    if (note.equals("Gb")) {
                        score[counter] = "G";
                        break;
                    }
                    if (note.equals("G")) {
                        score[counter] = "G#";
                        break;
                    }
                    if (!note.equals("G#")) break;
                    score[counter] = "A";
                }
            }
            int n = counter;
            score[n] = score[n] + octave;
        }
        return musicScore.transpose(score, halfSteps - 1);
    }

    public static String[] changeOctave(String[] score, int shift) {
        for (int counter = score.length - 1; counter >= 0; --counter) {
            if (score[counter].equals("")) continue;
            String note = score[counter].substring(0, score[counter].length() - 1);
            String octave = score[counter].substring(score[counter].length() - 1);
            String newOctave = Integer.toString(Integer.valueOf(octave) + shift);
            score[counter] = note + newOctave;
        }
        return score;
    }

    public void loadMIDIBPM(ArrayList<Integer> bpm) {
        ArrayList<Integer> newBPM = new ArrayList<Integer>();
        if (bpm.size() == 0) {
            if (Main.debugErrors) {
                System.out.println("BPM Vector is blank!");
            }
            this.BPMarray = new int[]{60};
        } else if (bpm.size() % 2 == 1) {
            if (Main.debugErrors) {
                System.out.println("BPM Vector's length should be even!");
            }
        } else {
            for (int c = bpm.size() - 1; c > 1; c -= 2) {
                bpm.set(c, bpm.get(c) - bpm.get(c - 2));
            }
            newBPM.add(bpm.remove(0));
            newBPM.add(bpm.remove(0));
            double beatCounter = 0.0;
            while (bpm.size() > 0) {
                double deltaBeats = (double)((Integer)newBPM.get(newBPM.size() - 2) * bpm.remove(1)) / 60.0;
                beatCounter += deltaBeats;
                if (deltaBeats > 1.0) {
                    newBPM.add(bpm.remove(0));
                    newBPM.add((int)beatCounter);
                    continue;
                }
                bpm.remove(0);
            }
            newBPM.remove(1);
            this.BPMarray = commonUtils.integerArrayListToArray(newBPM);
        }
    }

    private void printPart(String[] s) {
        try {
            for (int x = 0; x < s.length; ++x) {
                if (s[x].equals("")) {
                    System.out.print("_ ");
                } else {
                    System.out.print(s[x] + " ");
                }
                if (x % 20 != 19) continue;
                System.out.print('\n');
            }
        }
        catch (NullPointerException n) {
            System.out.print("Null");
        }
        System.out.print('\n');
    }

    private void printPart(float[] s) {
        try {
            for (int x = 0; x < s.length; ++x) {
                System.out.print(s[x] + " ");
                if (x % 20 != 19) continue;
                System.out.print('\n');
            }
        }
        catch (NullPointerException n) {
            System.out.print("Null");
        }
        System.out.print('\n');
    }

    private void printPart(int[] s) {
        try {
            for (int x = 0; x < s.length; ++x) {
                System.out.print(s[x] + " ");
                if (x % 20 != 19) continue;
                System.out.print('\n');
            }
        }
        catch (NullPointerException n) {
            System.out.print("Null");
        }
        System.out.print('\n');
    }

    public void BPMarrayBeatToPixValues() {
        for (int x = 2; x < this.BPMarray.length; x += 2) {
            int n = x;
            this.BPMarray[n] = this.BPMarray[n] * settings.PPB;
        }
    }
}

